#!/usr/bin/python3
# coding=utf-8

"me4 is named after M4, but it's perhaps simpler, and me wrote it meself."

from menu import *      # routines to import and travers the menu structure
from util import *      # little helpers

sitedir = "site"        # where the public website will be built
litdir = "lit"          # these files & directories will be literally copied
indir  = "articles"     # these files will be macro processed before writing
menufile = "articles/menu"  # path to menu file

infinite = 10           # how many loops are too many loops

# Do everything.
def run():
    # Backup files, if any, are here by accident.
    syscmd('find . -iname "*~" -delete')

    # Kill the previous build.
    syscmd('rm -rf %s' % sitedir)

    # Copy lit/ to the new locations. Use hard links to save space.
    syscmd('cp -lr %s %s' % (litdir, sitedir))

    # Load the menu information.
    menu = get_menu(menufile)

    # Generate site files using menu contents as a to-do list.
    walk_menu(menu, indir, sitedir)

run()
