#!/usr/bin/python3

from os import system

__all__ = 'oops slurp syscmd wherein'.split()

last_slurp = '?'

# quit with a conspicuous error message
def oops(msg):
    print('\x1b[1;33m%s\x1b[m' % msg)
    raise SystemExit

# read from a filename with suitable error handling
def slurp(fname):
    global last_slurp
    last_slurp = fname
    try:
        stuff = open(fname).read()
    except:
        oops('error opening [%s]' % fname)
    return stuff

# traceably do some system stuff
def syscmd(c):
    rc = system(c)
    print('    $ %s (%i)' % (c, rc))

# name of file being processed
def wherein():
    return last_slurp
